/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;

public final class Utility {
    public static final String INFO_PATH = "Info.xml";
    public static final String PROCESSDATA_PATH = "process_data.xml";
    public static final String PROCESSCYCLE_PATH = "process_data_block_";
    public static final String OPTION_PATH = "W&Hoptions.txt";
    public static final String LANGUAGE_TOKEN = "language=en-GB";
    private static String m_error = "";
    private static String m_state = "";
    public static final int SIZE = 10000;

    public static int uwChkSumSum(String html) {
        int uwChkSum = 0;
        byte[] byteArr = html.getBytes();
        int ulSize = byteArr.length;
        while (ulSize != 0) {
            if (byteArr[--ulSize] >= 0) {
                uwChkSum += byteArr[ulSize];
                continue;
            }
            uwChkSum += 256 + byteArr[ulSize];
        }
        return uwChkSum & 0xFFFF;
    }

    public static int ubCheckSum8(String html) {
        int ubCS8 = 0;
        int slIndex = 0;
        byte[] byteArr = html.getBytes();
        int ulSize = byteArr.length;
        while (slIndex < ulSize) {
            ubCS8 = ubCS8 >>> 1 | ubCS8 << 7;
            ubCS8 += byteArr[slIndex];
            ubCS8 &= 0xFF;
            ++slIndex;
        }
        return ubCS8;
    }

    public static String ValToHex2(int value) {
        int convertedvalue = value & 0xFF;
        String support = "00" + Integer.toString(convertedvalue, 16).toUpperCase();
        support = support.substring(support.length() - 2);
        return support;
    }

    public static void UploadFile(String fileName, String fileContent) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8);
            writer.write(fileContent);
            writer.close();
        }
        catch (IOException e) {
            m_error = "Invalid destination folder";
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    public static String[] DownloadFile(String fileName) {
        int count = 0;
        String[] result = new String[10000];
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String line = reader.readLine();
            while (line != null) {
                if (count == 0) {
                    result[0] = line;
                }
                if (count == 1) {
                    result[1] = line;
                }
                if (count == 2) {
                    result[2] = line;
                }
                if (count == 3) {
                    result[3] = line;
                }
                line = reader.readLine();
                ++count;
            }
            reader.close();
        }
        catch (IOException e) {
            m_error = "Impossible to load configuration file";
            e.printStackTrace();
        }
        return result;
    }

    public static String getUrlContents(String Url) {
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URL url = new URL(Url);
            URLConnection urlConnection = url.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(String.valueOf(line) + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            m_error = "Impossible to connect to device, check IP address";
            e.printStackTrace();
            System.out.println("Http request failed");
        }
        return content.toString();
    }

    public static boolean updateProcessDataBlock(String ipAddress, String index) {
        boolean isOk = true;
        String urlProcessDataBlock = "http://" + ipAddress + ":80/process_data_block.xml?protocol_id=";
        try {
            System.out.println(String.valueOf(urlProcessDataBlock) + index);
            OutputStreamWriter cycleFile = new OutputStreamWriter((OutputStream)new FileOutputStream(PROCESSCYCLE_PATH + index + ".xml"), StandardCharsets.UTF_8);
            cycleFile.write(Utility.getUrlContents(String.valueOf(urlProcessDataBlock) + index + "&" + LANGUAGE_TOKEN));
            cycleFile.close();
            System.out.println("Successfully wrote to the file.");
        }
        catch (IOException e) {
            isOk = false;
            m_error = "Impossible to download device file, check IP address";
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
        return isOk;
    }

    public static boolean updateInfo(String ipAddress) {
        boolean isOk = true;
        String urlInfoXml = "http://" + ipAddress + ":80/info.xml?" + LANGUAGE_TOKEN;
        try {
            if (!Utility.getUrlContents(urlInfoXml).isEmpty()) {
                OutputStreamWriter InfoXml = new OutputStreamWriter((OutputStream)new FileOutputStream(INFO_PATH), StandardCharsets.UTF_8);
                InfoXml.write(Utility.getUrlContents(urlInfoXml));
                InfoXml.close();
            } else {
                m_error = "Impossible to download device file, check IP address";
                isOk = false;
            }
        }
        catch (IOException e) {
            isOk = false;
            m_error = "Impossible to download device file, check IP address";
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
        return isOk;
    }

    public static boolean updateProcessData(String ipAddress) {
        boolean isOk = true;
        String urlProcessData = "http://" + ipAddress + ":80/process_data.xml?" + LANGUAGE_TOKEN;
        try {
            if (!Utility.getUrlContents(urlProcessData).isEmpty()) {
                OutputStreamWriter ProcessData = new OutputStreamWriter((OutputStream)new FileOutputStream(PROCESSDATA_PATH), StandardCharsets.UTF_8);
                ProcessData.write(Utility.getUrlContents(urlProcessData));
                ProcessData.close();
            } else {
                m_error = "Impossible to download device file, check IP address";
                isOk = false;
            }
        }
        catch (IOException e) {
            isOk = false;
            m_error = "Impossible to download device file, check IP address";
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
        return isOk;
    }

    public static void setError(String error) {
        m_error = error;
    }

    public static String getErrorFound() {
        return m_error;
    }

    public static void setApplicationState(String state) {
        m_state = state;
    }

    public static String getApplicationState() {
        return m_state;
    }
}

