/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser {
    public String parseCycle(String sourceFile) {
        String parseString = "";
        try {
            File inputFile = new File(sourceFile);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName(doc.getDocumentElement().getNodeName());
            parseString = XmlParser.visitChildNodes(nList);
            System.out.println(parseString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parseString;
    }

    public String parseCycleHtml(String sourceFile) {
        String html = "";
        try {
            File inputFile = new File(sourceFile);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName(doc.getDocumentElement().getNodeName());
            html = XmlParser.visitChildNodesHTML(nList);
            System.out.println(html);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return html;
    }

    private static String visitChildNodesHTML(NodeList nList) {
        ArrayList<String> exceptionList = new ArrayList<String>(5);
        exceptionList.add("id");
        exceptionList.add("time_start");
        exceptionList.add("time_end");
        exceptionList.add("state");
        exceptionList.add("program");
        String result = "";
        int temp = 0;
        while (temp < nList.getLength()) {
            Node node = nList.item(temp);
            if (node.getNodeType() == 1 && node.hasChildNodes()) {
                if (node.getChildNodes().getLength() == 1) {
                    String content = node.getTextContent().replaceAll("\\s", "");
                    if (!content.isEmpty()) {
                        System.out.println(node.getNodeName());
                        result = exceptionList.contains(node.getNodeName()) ? String.valueOf(result) + "<tr><td><strong>" + node.getNodeName() + "</strong></td><td>" + node.getTextContent() + "</td></tr>\n" : String.valueOf(result) + "<tr align=center><td>" + node.getNodeName() + "</td><td>" + node.getTextContent() + "</td></tr>\n";
                    }
                } else if (node.getNodeName() == "process_data_block") {
                    String title = "Cycle data:";
                    result = String.valueOf(result) + "<td><strong>" + title + "</strong></td>\n";
                } else {
                    result = String.valueOf(result) + "<td><strong>" + node.getNodeName() + "</strong></td>\n";
                }
                result = String.valueOf(result) + XmlParser.visitChildNodesHTML(node.getChildNodes());
            }
            ++temp;
        }
        return result;
    }

    private static String visitChildNodes(NodeList nList) {
        String result = "";
        int temp = 0;
        while (temp < nList.getLength()) {
            Node node = nList.item(temp);
            if (node.getNodeType() == 1 && node.hasChildNodes()) {
                if (node.getChildNodes().getLength() == 1) {
                    String content = node.getTextContent().replaceAll("\\s", "");
                    if (!content.isEmpty()) {
                        result = String.valueOf(result) + "\n \t" + node.getNodeName() + " = " + node.getTextContent();
                    }
                } else {
                    result = String.valueOf(result) + "\n" + node.getNodeName();
                }
                result = String.valueOf(result) + XmlParser.visitChildNodes(node.getChildNodes());
            }
            ++temp;
        }
        return result;
    }

    public int parseCycleCount(String sourceFile) {
        int nCount = 0;
        try {
            File inputFile = new File(sourceFile);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("protocol_block_type");
            Node nCountNode = nList.item(0);
            if (nCountNode.getNodeType() == 1) {
                Element eElement = (Element)nCountNode;
                nCount = Integer.parseInt(eElement.getElementsByTagName("count").item(0).getTextContent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(nCount);
        return nCount;
    }

    public List<String> parseCycleHistory(String sourceFile) {
        ArrayList<String> cycleIDList = new ArrayList<String>();
        try {
            File inputFile = new File(sourceFile);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("protocol");
            int temp = 0;
            while (temp < nList.getLength()) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() == 1) {
                    Element eElement = (Element)nNode;
                    cycleIDList.add(eElement.getElementsByTagName("id").item(0).getTextContent());
                }
                ++temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(cycleIDList);
        return cycleIDList;
    }

    public List<String> parseInfo(String sourceFile) {
        ArrayList<String> cycleIDList = new ArrayList<String>();
        try {
            File inputFile = new File(sourceFile);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("device");
            int temp = 0;
            while (temp < nList.getLength()) {
                Node nNode = nList.item(temp);
                System.out.println("\nCurrent Element :" + nNode.getNodeName());
                if (nNode.getNodeType() == 1) {
                    Element eElement = (Element)nNode;
                    cycleIDList.add(eElement.getElementsByTagName("sw_id").item(0).getTextContent());
                    cycleIDList.add(eElement.getElementsByTagName("el_fabnr").item(0).getTextContent());
                }
                ++temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cycleIDList;
    }
}

