/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class GUIManager {
    private Timer m_timer;
    private Timer m_timerFiles;
    private MainFrame m_mainFrame;
    private OptionsFrame m_optionsFrame;
    private AboutFrame m_aboutFrame;
    private DataManager m_dataMgr;
    private LoadingBox m_loadingBox;
    private Thread m_initBkThread;
    private Thread m_convertBkThread;
    private Thread m_loadingBkThread;

    public GUIManager(DataManager dataMgr) {
        this.m_dataMgr = dataMgr;
        this.m_timer = null;
        this.m_mainFrame = null;
    }

    public void init() {
        this.dataMgrInit();
        this.m_mainFrame = new MainFrame(this);
        this.m_mainFrame.createLayout();
        this.m_mainFrame.setVisible(true);
        this.showError();
        this.showReportData();
        if (Utility.getErrorFound() == "") {
            this.startAutoMode();
            this.checkNewFileNumber();
        }
    }

    public void dataMgrInit() {
        this.m_initBkThread = new Thread(){

            @Override
            public void run() {
                GUIManager.this.m_dataMgr.init();
            }
        };
        if (this.m_initBkThread != null && !this.m_initBkThread.isAlive()) {
            this.m_initBkThread.start();
        }
        if (this.m_initBkThread != null) {
            this.m_initBkThread.interrupt();
            try {
                this.m_initBkThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.m_initBkThread = null;
        }
    }

    public void checkNewFileNumber() {
        if (this.m_timerFiles == null) {
            this.m_timerFiles = new Timer();
            this.m_timerFiles.schedule(new TimerTask(){

                @Override
                public void run() {
                    GUIManager.this.showError();
                    GUIManager.this.showReportData();
                }
            }, 3000L, Long.valueOf(1L) * 5000L);
        }
    }

    public void startAutoMode() {
        if (this.m_timer == null) {
            this.m_timer = new Timer();
            this.m_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    GUIManager.this.convertXMLFiles();
                }
            }, 3000L, Long.valueOf(1L) * (long)this.m_dataMgr.getWaitTime() * 1000L * 120L);
        }
    }

    public void stopAutoMode() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer.purge();
            this.m_timer = null;
        }
    }

    public void convertXMLFiles() {
        this.m_convertBkThread = new Thread(){

            @Override
            public void run() {
                GUIManager.this.m_dataMgr.convertNewXMLFiles();
            }
        };
        if (this.m_convertBkThread != null && !this.m_convertBkThread.isAlive()) {
            this.m_convertBkThread.start();
        }
        if (this.m_convertBkThread != null) {
            this.m_convertBkThread.interrupt();
            try {
                this.m_convertBkThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.m_convertBkThread = null;
        }
    }

    public void openDestinationFolder() {
        block5: {
            if (!this.m_dataMgr.getDestFolder().isEmpty()) {
                try {
                    File destinationFolder = new File(this.m_dataMgr.getDestFolder());
                    if (destinationFolder.exists()) {
                        Desktop.getDesktop().open(destinationFolder);
                        break block5;
                    }
                    MsgBox.error("Invalid destination folder");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                MsgBox.error("Empty destination folder");
            }
        }
    }

    public void notifyOptionsFrame() {
        this.m_optionsFrame = new OptionsFrame(this);
        this.m_optionsFrame.createLayout();
        this.m_optionsFrame.setIPAddress(this.m_dataMgr.getIPAddress());
        this.m_optionsFrame.setDestinationPath(this.m_dataMgr.getDestFolder());
        this.m_optionsFrame.setTimerAutoMode(this.m_dataMgr.getWaitTime());
        this.m_optionsFrame.setVisible(true);
    }

    public void notifyOptionsChange(String IPAddress, String destFolder, int time) {
        this.saveNewParameter(IPAddress, destFolder, time);
        this.m_optionsFrame.dispose();
        this.m_optionsFrame = null;
        Utility.setApplicationState("Parameters stored");
        this.showReportData();
        Utility.setError("");
        this.showError();
        this.stopAutoMode();
        this.startAutoMode();
    }

    public void saveNewParameter(final String IPAddress, final String destFolder, final int time) {
        this.m_loadingBox = new LoadingBox();
        this.m_loadingBox.createLayout();
        this.m_loadingBkThread = new Thread(){

            @Override
            public void run() {
                GUIManager.this.m_dataMgr.setConfigParameter(IPAddress, destFolder, time);
                GUIManager.this.m_loadingBox.dispose();
                GUIManager.this.m_loadingBox = null;
            }
        };
        if (this.m_loadingBkThread != null && !this.m_loadingBkThread.isAlive()) {
            this.m_loadingBkThread.start();
        }
        this.m_loadingBox.setVisible(true);
        if (this.m_loadingBkThread != null) {
            this.m_loadingBkThread.interrupt();
            try {
                this.m_loadingBkThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.m_loadingBkThread = null;
        }
    }

    public void notifyAboutFrame() {
        this.m_aboutFrame = new AboutFrame();
        this.m_aboutFrame.createLayout();
        this.m_aboutFrame.setVisible(true);
    }

    public void showError() {
        String error = Utility.getErrorFound();
        this.m_mainFrame.setError(error);
    }

    public void showReportData() {
        String info = Utility.getApplicationState();
        this.m_mainFrame.setApplicationState(info);
    }
}

