/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptionsFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private JLabel m_labelIPAddress;
    private JTextField m_txtIPAddress;
    private JLabel m_labelDestFolder;
    private JTextField m_txtDestFolder;
    private JButton m_btnDestFolder;
    private JLabel m_labelTimerAutoMode;
    private JTextField m_txtTimerAutoMode;
    private JButton m_btnCancel;
    private JButton m_btnOk;
    private GUIManager m_GUIManagerParent;

    public OptionsFrame(GUIManager GUIManagerParent) {
        super("Teon/Teon + Manager options");
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon mainIcon = new ImageIcon(url);
        this.setIconImage(mainIcon.getImage());
        this.addWindowListener(this);
        this.m_GUIManagerParent = GUIManagerParent;
    }

    public void createLayout() {
        Font font = new Font("HelveticaNeueWorld-45Lt", 0, 16);
        this.m_labelIPAddress = new JLabel("Device IP address");
        this.m_labelIPAddress.setFont(font);
        this.m_txtIPAddress = new JTextField(20);
        this.m_txtIPAddress.setFont(font);
        this.m_labelDestFolder = new JLabel("Destination folder");
        this.m_labelDestFolder.setFont(font);
        this.m_btnDestFolder = new JButton("Browse...");
        URL url = MainFrame.class.getResource("/resource/folder.png");
        this.m_btnDestFolder.setIcon(new ImageIcon(url));
        this.m_btnDestFolder.setIconTextGap(12);
        this.m_btnDestFolder.setFont(font);
        this.m_txtDestFolder = new JTextField(20);
        this.m_txtDestFolder.setFont(font);
        this.m_labelTimerAutoMode = new JLabel("Synchronization time (minutes)");
        this.m_labelTimerAutoMode.setFont(font);
        this.m_txtTimerAutoMode = new JTextField(20);
        this.m_txtTimerAutoMode.setHorizontalAlignment(4);
        this.m_txtTimerAutoMode.setFont(font);
        this.m_btnOk = new JButton("Ok");
        this.m_btnOk.setFont(font);
        url = MainFrame.class.getResource("/resource/ok.png");
        this.m_btnOk.setIcon(new ImageIcon(url));
        this.m_btnCancel = new JButton("Cancel");
        this.m_btnCancel.setFont(font);
        url = MainFrame.class.getResource("/resource/cancel.png");
        this.m_btnCancel.setIcon(new ImageIcon(url));
        this.m_btnDestFolder.addActionListener(new DestFolderBtnListener(this));
        this.m_btnCancel.addActionListener(new CancelOptionsBtnListener(this));
        this.m_btnOk.addActionListener(new OkOptionsBtnListener(this));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.addComponent(mainPanel, this.m_labelIPAddress, 0, 0, 4, 1, 10, 1, 15, 5, 10, 0);
        this.addComponent(mainPanel, this.m_txtIPAddress, 0, 1, 4, 1, 10, 1, 15, 15, 0, 20);
        this.addComponent(mainPanel, this.m_labelDestFolder, 0, 2, 4, 1, 10, 1, 15, 5, 10, 0);
        this.addComponent(mainPanel, this.m_txtDestFolder, 0, 3, 3, 1, 10, 1, 15, 0, 0, 20);
        this.addComponent(mainPanel, this.m_btnDestFolder, 3, 3, 1, 1, 10, 1, 0, 15, 0, 20);
        this.addComponent(mainPanel, this.m_labelTimerAutoMode, 0, 4, 4, 1, 10, 1, 15, 5, 10, 0);
        this.addComponent(mainPanel, this.m_txtTimerAutoMode, 0, 5, 4, 1, 10, 1, 15, 15, 0, 20);
        this.addComponent(mainPanel, this.m_btnOk, 0, 6, 2, 1, 10, 1, 15, 150, 0, 10);
        this.addComponent(mainPanel, this.m_btnCancel, 2, 6, 2, 1, 10, 1, 15, 15, 0, 10);
        this.add(mainPanel);
        this.setSize(500, 380);
        this.setMinimumSize(this.getSize());
        this.setMaximumSize(this.getSize());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, int borderLeft, int borderRight, int borderTop, int borderBottom) {
        Insets insets = new Insets(borderTop, borderLeft, borderBottom, borderRight);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    public void setIPAddress(String IPAddress) {
        this.m_txtIPAddress.setText(IPAddress);
    }

    public void setDestinationPath(String destDirectory) {
        this.m_txtDestFolder.setText(destDirectory);
    }

    public void setTimerAutoMode(int time) {
        this.m_txtTimerAutoMode.setText(String.valueOf(time));
    }

    public void notifyOptionsChange() {
        String IPAddress = this.m_txtIPAddress.getText();
        String destDirectory = this.m_txtDestFolder.getText();
        String time = this.m_txtTimerAutoMode.getText();
        if (IPAddress.isEmpty() || destDirectory.isEmpty() || time.isEmpty()) {
            MsgBox.error("Wrong input data");
        } else if (!this.checkIPAddress(IPAddress)) {
            MsgBox.error("IP format not valid");
        } else if (Integer.parseInt(time) <= 0) {
            MsgBox.error("Value of time must be positive or greater than 0");
        } else {
            this.m_GUIManagerParent.notifyOptionsChange(IPAddress, destDirectory, Integer.parseInt(time));
        }
    }

    public boolean checkIPAddress(String IPAddress) {
        String zeroTo255 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String regex = String.valueOf(zeroTo255) + "\\." + zeroTo255 + "\\." + zeroTo255 + "\\." + zeroTo255;
        Pattern p = Pattern.compile(regex);
        if (IPAddress == null) {
            return false;
        }
        Matcher m = p.matcher(IPAddress);
        return m.matches();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class CancelOptionsBtnListener
    implements ActionListener {
        private OptionsFrame m_MainParent;

        public CancelOptionsBtnListener(OptionsFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.m_MainParent.dispose();
        }
    }

    class DestFolderBtnListener
    implements ActionListener {
        private OptionsFrame m_MainParent;

        public DestFolderBtnListener(OptionsFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileHidingEnabled(false);
            int result = fileChooser.showOpenDialog(this.m_MainParent);
            if (result == 0) {
                File destFile = fileChooser.getSelectedFile();
                this.m_MainParent.setDestinationPath(destFile.getAbsolutePath());
            }
        }
    }

    class OkOptionsBtnListener
    implements ActionListener {
        private OptionsFrame m_MainParent;

        public OkOptionsBtnListener(OptionsFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.m_MainParent.notifyOptionsChange();
            this.m_MainParent.dispose();
        }
    }
}

