/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MainFrame
extends JFrame
implements WindowListener,
MenuListener {
    private static final long serialVersionUID = 1L;
    private JLabel m_labelConvertedFileNumber;
    private JLabel m_labelError;
    private JLabel m_labelIcon;
    private JButton m_btnCheckConvertedFileNumber;
    private GUIManager m_GUIManagerParent;

    public MainFrame(GUIManager GUIManagerParent) {
        super("Teon/Teon + Manager");
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon mainIcon = new ImageIcon(url);
        this.setIconImage(mainIcon.getImage());
        this.addWindowListener(this);
        this.m_GUIManagerParent = GUIManagerParent;
    }

    public void createLayout() {
        JMenuBar menuBar = new JMenuBar();
        JMenu mainMenu = this.getMainMenu();
        mainMenu.addMenuListener(this);
        menuBar.add(mainMenu);
        this.setJMenuBar(menuBar);
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon imageIcon = new ImageIcon(new ImageIcon(url).getImage().getScaledInstance(200, 104, 4));
        this.m_labelIcon = new JLabel(imageIcon);
        Font fontSeals = new Font("HelveticaNeueWorld-45Lt", 0, 16);
        this.m_labelConvertedFileNumber = new JLabel("");
        this.m_labelConvertedFileNumber.setHorizontalAlignment(0);
        this.m_labelConvertedFileNumber.setFont(fontSeals);
        Font fontError = new Font("HelveticaNeueWorld-45Lt", 1, 16);
        this.m_labelError = new JLabel("");
        this.m_labelError.setHorizontalAlignment(0);
        this.m_labelError.setFont(fontError);
        this.m_labelError.setForeground(Color.red);
        Font fontCheck = new Font("HelveticaNeueWorld-45Lt", 0, 16);
        this.m_btnCheckConvertedFileNumber = new JButton("Check device logs");
        this.m_btnCheckConvertedFileNumber.addActionListener(new CheckConvertedFileListener(this));
        url = MainFrame.class.getResource("/resource/html.png");
        this.m_btnCheckConvertedFileNumber.setIcon(new ImageIcon(url));
        this.m_btnCheckConvertedFileNumber.setFont(fontCheck);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.addComponent(mainPanel, this.m_labelIcon, 0, 1, 3, 1, 10, 1, 5, 5);
        this.addComponent(mainPanel, this.m_labelConvertedFileNumber, 0, 2, 3, 1, 10, 1, 5, 5);
        this.addComponent(mainPanel, this.m_labelError, 0, 3, 3, 1, 10, 1, 5, 5);
        this.addComponent(mainPanel, this.m_btnCheckConvertedFileNumber, 0, 4, 3, 1, 10, 1, 5, 5);
        this.add(mainPanel);
        this.setSize(650, 400);
        this.setMinimumSize(this.getSize());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private JMenu getMainMenu() {
        JMenu mainMenu = new JMenu("Menu");
        JMenuItem optionsItem = new JMenuItem("Options");
        mainMenu.add(optionsItem);
        optionsItem.addActionListener(new OptionsListener(this));
        JMenuItem aboutItem = new JMenuItem("About");
        mainMenu.add(aboutItem);
        aboutItem.addActionListener(new AboutListener(this));
        return mainMenu;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, int borderLeft, int borderRight) {
        Insets insets = new Insets(10, borderLeft, 10, borderRight);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    public void notifyCheckSeal() {
        this.m_GUIManagerParent.openDestinationFolder();
    }

    public void notifyOptionsFrame() {
        this.m_GUIManagerParent.notifyOptionsFrame();
    }

    public void notifyAboutFrame() {
        this.m_GUIManagerParent.notifyAboutFrame();
    }

    public void setApplicationState(String msgToShow) {
        this.m_labelConvertedFileNumber.setText(msgToShow);
        this.m_labelConvertedFileNumber.setVisible(true);
    }

    public void setError(String error) {
        this.m_labelError.setText(error);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public class AboutListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public AboutListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyAboutFrame();
        }
    }

    public class CheckConvertedFileListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public CheckConvertedFileListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyCheckSeal();
        }
    }

    public class OptionsListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public OptionsListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyOptionsFrame();
        }
    }
}

