/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class DataManager {
    public final String SOTWARE_REVISION = "2.0";
    public final String PREFIX_FILE = "W&H_";
    public final String SUFFIX_FILE = "html";
    public final String SUFFIX_BACKUPFILE = "txt";
    public final String FOLDER_BACKUPFILE = "W&H_BACKUP";
    private String m_IPAddress;
    private String m_destFolder;
    private int m_pollingTime = 60;
    private int m_lastSavedCycle = 0;
    private MachineData m_machineInfo = new MachineData();

    public DataManager() {
        this.m_IPAddress = new String();
        this.m_destFolder = new String();
    }

    public void init() {
        this.loadConfigFile();
        this.loadInfo();
        int count = this.getMissingCycles();
        if (count > 0) {
            Utility.setError(String.valueOf(count) + " cycles lost");
        }
    }

    public int getMissingCycles() {
        int missingCount = 0;
        if (this.checkParameter()) {
            Utility.updateProcessData(this.m_IPAddress);
            Path path = Paths.get("process_data.xml", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                XmlParser parser = new XmlParser();
                List<String> cycleList = parser.parseCycleHistory("process_data.xml");
                if (this.m_lastSavedCycle != 0) {
                    String lastCycle = cycleList.get(cycleList.size() - 1);
                    int firstCycle = Integer.parseInt(lastCycle);
                    int lastCycleSaved = this.m_lastSavedCycle;
                    missingCount = firstCycle - (lastCycleSaved + 1);
                }
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Utility.setError("Set correct options");
        }
        return missingCount;
    }

    public void loadConfigFile() {
        Path path = Paths.get("W&Hoptions.txt", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Utility.setApplicationState("Configuration loading...");
            String[] result = Utility.DownloadFile("W&Hoptions.txt");
            this.m_IPAddress = result[0];
            this.m_destFolder = result[1];
            File dir = new File(this.m_destFolder);
            if (!dir.exists()) {
                dir.mkdir();
            }
            this.m_pollingTime = Integer.parseInt(result[2]);
            if (result[3] != null && !result[3].isEmpty()) {
                this.m_lastSavedCycle = Integer.parseInt(result[3]);
            }
        }
    }

    public void loadInfo() {
        if (this.checkParameter()) {
            Utility.updateInfo(this.m_IPAddress);
            Path path = Paths.get("Info.xml", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                Utility.setApplicationState("Info loading...");
                this.m_machineInfo.importMachineData("Info.xml");
            }
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Utility.setError("Set correct options");
        }
    }

    public boolean checkParameter() {
        boolean isOk = true;
        isOk &= !this.m_IPAddress.isEmpty();
        return isOk &= !this.m_destFolder.isEmpty();
    }

    private String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public List<String> listFilesForFolder(String sourceDir) {
        File folder = new File(sourceDir);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> cycleList = new ArrayList<String>();
        File[] fileArray = listOfFiles;
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().contains("W&H_") && this.getFileExtension(file).compareTo("html") == 0) {
                cycleList.add(file.getName());
            }
            ++n2;
        }
        return cycleList;
    }

    public void convertNewXMLFiles() {
        if (this.checkParameter()) {
            Utility.setError("");
            Utility.setApplicationState("Device loading...");
            Utility.updateProcessData(this.m_IPAddress);
            Path pathProcessData = Paths.get("process_data.xml", new String[0]);
            if (Files.exists(pathProcessData, new LinkOption[0])) {
                XmlParser parser = new XmlParser();
                List<String> cycleList = parser.parseCycleHistory("process_data.xml");
                List<String> oldList = this.listFilesForFolder(this.m_destFolder);
                int i = 0;
                while (i < cycleList.size()) {
                    if (!oldList.contains("W&H_" + cycleList.get(i) + "." + "html")) {
                        Utility.updateProcessDataBlock(this.m_IPAddress, cycleList.get(i));
                        String html = this.getHeaderHtml(cycleList.get(i));
                        html = String.valueOf(html) + parser.parseCycleHtml("process_data_block_" + cycleList.get(i) + ".xml");
                        html = this.getEnderHtml(html);
                        Utility.UploadFile(String.valueOf(this.m_destFolder) + "/" + "W&H_" + cycleList.get(i) + "." + "html", html);
                        File backupFolder = new File("W&H_BACKUP");
                        if (!backupFolder.exists()) {
                            backupFolder.mkdir();
                        }
                        String backup = parser.parseCycle("process_data_block_" + cycleList.get(i) + ".xml");
                        Utility.UploadFile(backupFolder + "/" + "W&H_" + cycleList.get(i) + "." + "txt", backup);
                        Path path = Paths.get("process_data_block_" + cycleList.get(i) + ".xml", new String[0]);
                        try {
                            Files.delete(path);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (i == 0) {
                            this.m_lastSavedCycle = Integer.parseInt(cycleList.get(i));
                        }
                    }
                    ++i;
                }
                this.storeParameter();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
                LocalDateTime now = LocalDateTime.now();
                Utility.setApplicationState("<html><span style=\"font-family:HelveticaNeueWorld-45Lt;font-size:13px;\">Last synchronization performed: </span>" + dtf.format(now) + "<span style=\\\"font-family:HelveticaNeueWorld-45Lt;font-size:13px;\\\"></span></html>");
                Utility.setError("");
                try {
                    Files.delete(pathProcessData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Utility.setError("Set correct options");
        }
    }

    public String getHeaderInfo() {
        String info = "";
        info = String.valueOf(info) + "W&H Sterilization\n";
        info = String.valueOf(info) + "Teon/Teon + Manager \t \t SN:" + this.m_machineInfo.getMachineSN() + "\n";
        info = String.valueOf(info) + "Software WH revision: 2.0\n";
        info = String.valueOf(info) + "Software revision: \n";
        info = String.valueOf(info) + "Firmware version:\n";
        return info;
    }

    public String getFooter() {
        return "";
    }

    public String getControlCode(String fileContent, String footer) {
        int uwSum = Utility.uwChkSumSum(fileContent);
        int ubChkSum = Utility.ubCheckSum8(fileContent);
        int[] RawControlCode = new int[8];
        byte[] byteArrHtml = fileContent.getBytes();
        byte[] byteArrFooter = footer.getBytes();
        int ulDimFile = byteArrHtml.length + RawControlCode.length * 2 + byteArrFooter.length;
        RawControlCode[0] = ulDimFile >>> 24 & 0xFF;
        RawControlCode[1] = ulDimFile >>> 16 & 0xFF;
        RawControlCode[2] = ulDimFile >>> 8 & 0xFF;
        RawControlCode[3] = ulDimFile & 0xFF;
        RawControlCode[4] = ubChkSum & 0xFF;
        RawControlCode[5] = uwSum >>> 8 & 0xFF;
        RawControlCode[6] = uwSum & 0xFF;
        int ubCS8 = 0;
        int ulIndex = 0;
        while (ulIndex < 7) {
            ubCS8 = (ubCS8 >>> 1 | ubCS8 << 7) & 0xFF;
            ubCS8 += RawControlCode[ulIndex];
            ubCS8 &= 0xFF;
            ++ulIndex;
        }
        RawControlCode[7] = ubCS8;
        ulIndex = 0;
        while (ulIndex < 4) {
            int n = 0 + ulIndex;
            RawControlCode[n] = RawControlCode[n] ^ ~((byte)RawControlCode[4 + ulIndex]);
            ++ulIndex;
        }
        String ControlCode = "";
        ulIndex = 0;
        while (ulIndex < RawControlCode.length) {
            ControlCode = String.valueOf(ControlCode) + Utility.ValToHex2(RawControlCode[ulIndex]);
            ++ulIndex;
        }
        return ControlCode;
    }

    public int getWaitTime() {
        return this.m_pollingTime;
    }

    public String getIPAddress() {
        return this.m_IPAddress;
    }

    public String getDestFolder() {
        return this.m_destFolder;
    }

    public void storeParameter() {
        String fileContent = String.valueOf(this.m_IPAddress) + "\n" + this.m_destFolder + "\n" + this.m_pollingTime + "\n" + this.m_lastSavedCycle;
        Utility.UploadFile("W&Hoptions.txt", fileContent);
    }

    public void setConfigParameter(String IPAddress, String destFolder, int time) {
        this.m_IPAddress = IPAddress;
        this.m_destFolder = destFolder;
        this.m_pollingTime = time;
        this.storeParameter();
        this.loadInfo();
    }

    public String getEnderHtml(String htmlBody) {
        String html = htmlBody;
        html = String.valueOf(html) + "<table width=400>\n";
        html = String.valueOf(html) + "</table>\n";
        html = String.valueOf(html) + "</body>\n";
        html = String.valueOf(html) + "<!-- Original_Data_Control_Code=\"";
        html = String.valueOf(html) + this.getControlCode(html, "\" -->\n</html>");
        html = String.valueOf(html) + "\" -->\n</html>";
        return html;
    }

    public String getHeaderHtml(String index) {
        String html = "<html><head>";
        html = String.valueOf(html) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>";
        html = String.valueOf(html) + "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/>";
        html = String.valueOf(html) + "<title>";
        html = String.valueOf(html) + "W&H Sterilization";
        html = String.valueOf(html) + " </title>";
        html = String.valueOf(html) + "</head>\n";
        html = String.valueOf(html) + "<!-- DeviceBrandID=\"";
        html = String.valueOf(html) + "\" DeviceBrand=\"W&H Sterilization";
        html = String.valueOf(html) + "\" DeviceSN=\"" + this.m_machineInfo.getMachineSN();
        html = String.valueOf(html) + "\" -->\n";
        html = String.valueOf(html) + "<body>";
        html = String.valueOf(html) + "<body><table width=400 cellpadding=1>\n";
        html = String.valueOf(html) + "<tr align=center><td colspan=\"7\"/><b>W&H Sterilization</b></td></tr>\n";
        html = String.valueOf(html) + "</b></td></tr></table>\n";
        html = String.valueOf(html) + "<table width=400>\n";
        html = String.valueOf(html) + "<tr align=left><td colspan=\"2\"><b>Model:</b></td><td colspan=\"3\">" + this.m_machineInfo.getMachineName() + "</td></tr> \n";
        html = String.valueOf(html) + "<tr align=left><td colspan=\"2\"><b>SN:</b></td><td colspan=\"3\">" + this.m_machineInfo.getMachineSN() + "</td></tr> \n";
        html = String.valueOf(html) + "<tr align=left><td colspan=\"2\"><b>Software revision: </b></td><td colspan=\"3\">" + this.m_machineInfo.getSoftwareRevision() + "</td></tr> \n";
        html = String.valueOf(html) + "<tr><td colspan=\"5\"><hr size=2></td></tr></table> \n";
        html = String.valueOf(html) + "<table width=400 bgcolor=\"#F8F8F8\"> \n";
        return html;
    }
}

