/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptionsFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private JLabel m_labelTimerAutoMode;
    private JTextField m_txtTimerAutoMode;
    private JCheckBox m_checkAutoMode;
    private JButton m_btnCancel;
    private JButton m_btnOk;
    private GUIManager m_GUIManagerParent;
    private MainFrame m_mainFrame;

    public OptionsFrame(GUIManager GUIManagerParent) {
        super("SealVal\u00b2 Options");
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon mainIcon = new ImageIcon(url);
        this.setIconImage(mainIcon.getImage());
        this.addWindowListener(this);
        this.m_GUIManagerParent = GUIManagerParent;
        this.m_mainFrame = new MainFrame(GUIManagerParent);
    }

    public void createLayout() {
        Font font = new Font("HelveticaNeueWorld-45Lt", 0, 16);
        this.m_labelTimerAutoMode = new JLabel("Synchronization in Automatic Mode (sec)");
        this.m_labelTimerAutoMode.setFont(font);
        this.m_btnOk = new JButton("Ok");
        this.m_btnOk.setFont(font);
        URL url = MainFrame.class.getResource("/resource/ok.png");
        this.m_btnOk.setIcon(new ImageIcon(url));
        this.m_btnCancel = new JButton("Cancel");
        this.m_btnCancel.setFont(font);
        url = MainFrame.class.getResource("/resource/cancel.png");
        this.m_btnCancel.setIcon(new ImageIcon(url));
        this.m_txtTimerAutoMode = new JTextField(20);
        this.m_txtTimerAutoMode.setHorizontalAlignment(4);
        this.m_txtTimerAutoMode.setFont(font);
        this.m_txtTimerAutoMode.setText(Integer.toString(DataManager.m_pollingTime));
        this.m_checkAutoMode = new JCheckBox("Enable/Disable Auto mode", DataManager.m_autoMode);
        this.m_checkAutoMode.setFont(font);
        this.m_btnCancel.addActionListener(new CancelOptionsBtnListener(this));
        this.m_btnOk.addActionListener(new OkOptionsBtnListener(this));
        this.m_checkAutoMode.addActionListener(new changeCheckAutoMode(this));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.addComponent(mainPanel, this.m_labelTimerAutoMode, 0, 0, 4, 1, 10, 1, 15, 15, 5, 5);
        this.addComponent(mainPanel, this.m_txtTimerAutoMode, 0, 1, 4, 1, 10, 1, 15, 15, 5, 5);
        this.addComponent(mainPanel, this.m_btnOk, 0, 3, 1, 1, 10, 1, 15, 15, 5, 15);
        this.addComponent(mainPanel, this.m_btnCancel, 2, 3, 1, 1, 10, 1, 15, 15, 5, 15);
        this.addComponent(mainPanel, this.m_checkAutoMode, 0, 2, 4, 1, 10, 1, 15, 15, 0, 5);
        this.add(mainPanel);
        this.setSize(350, 200);
        this.setMinimumSize(this.getSize());
        this.setMaximumSize(this.getSize());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        if (DataManager.m_autoMode) {
            this.m_txtTimerAutoMode.setEnabled(true);
        } else {
            this.m_txtTimerAutoMode.setEnabled(false);
        }
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, int borderLeft, int borderRight, int borderTop, int borderBottom) {
        Insets insets = new Insets(borderTop, borderLeft, borderBottom, borderRight);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    public void notifyCheckBoxChange() {
        DataManager.m_autoMode = this.m_checkAutoMode.isSelected();
        if (this.m_checkAutoMode.isSelected()) {
            this.m_txtTimerAutoMode.setEnabled(true);
        } else {
            this.m_txtTimerAutoMode.setEnabled(false);
        }
        Utility.UploadFile(Utility.OPTION_PATH);
    }

    public void notifyOptionsChange() {
        if (this.m_txtTimerAutoMode.getText().isEmpty()) {
            MsgBox.error("Input data wrong");
        } else {
            DataManager.m_pollingTime = Integer.parseInt(this.m_txtTimerAutoMode.getText());
            this.m_GUIManagerParent.notifyOptionsChange(Integer.parseInt(this.m_txtTimerAutoMode.getText()));
            Utility.UploadFile(Utility.OPTION_PATH);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        boolean autoModeFrame = false;
        if (this.m_checkAutoMode.isSelected()) {
            autoModeFrame = true;
        }
        this.m_mainFrame.showAutoMode(autoModeFrame);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class CancelOptionsBtnListener
    implements ActionListener {
        private OptionsFrame m_MainParent;

        public CancelOptionsBtnListener(OptionsFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.m_MainParent.dispose();
        }
    }

    class OkOptionsBtnListener
    implements ActionListener {
        private OptionsFrame m_MainParent;

        public OkOptionsBtnListener(OptionsFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.m_MainParent.notifyOptionsChange();
            this.m_MainParent.dispose();
        }
    }

    class changeCheckAutoMode
    implements ActionListener {
        private OptionsFrame m_MainParent;

        public changeCheckAutoMode(OptionsFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainParent.notifyCheckBoxChange();
        }
    }
}

