/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MainFrame
extends JFrame
implements WindowListener,
MenuListener {
    private static final long serialVersionUID = 1L;
    private static JLabel m_labelAutomaticMode;
    private JLabel m_labelImportSeal;
    private JLabel m_labelError;
    private JLabel m_labelIcon;
    private JButton m_btnCheckSeal;
    private GUIManager m_GUIManagerParent;

    public MainFrame(GUIManager GUIManagerParent) {
        super("SealVal\u00b2 Manager");
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon mainIcon = new ImageIcon(url);
        this.setIconImage(mainIcon.getImage());
        this.addWindowListener(this);
        this.m_GUIManagerParent = GUIManagerParent;
    }

    public void createLayout(boolean existFile) {
        JMenuBar menuBar = new JMenuBar();
        JMenu mainMenu = this.getMainMenu();
        mainMenu.addMenuListener(this);
        menuBar.add(mainMenu);
        this.setJMenuBar(menuBar);
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon imageIcon = new ImageIcon(new ImageIcon(url).getImage().getScaledInstance(200, 104, 4));
        this.m_labelIcon = new JLabel(imageIcon);
        Font font = new Font("HelveticaNeueWorld-45Lt", 1, 20);
        m_labelAutomaticMode = new JLabel("Automatic Mode");
        url = MainFrame.class.getResource("/resource/Automode.png");
        m_labelAutomaticMode.setIcon(new ImageIcon(url));
        m_labelAutomaticMode.setHorizontalAlignment(0);
        m_labelAutomaticMode.setFont(font);
        m_labelAutomaticMode.setVisible(false);
        Font fontSeals = new Font("HelveticaNeueWorld-45Lt", 0, 24);
        this.m_labelImportSeal = new JLabel("");
        this.m_labelImportSeal.setHorizontalAlignment(0);
        this.m_labelImportSeal.setFont(fontSeals);
        Font fontError = new Font("HelveticaNeueWorld-45Lt", 1, 16);
        this.m_labelError = new JLabel("");
        this.m_labelError.setHorizontalAlignment(0);
        this.m_labelError.setFont(fontError);
        this.m_labelError.setForeground(Color.red);
        Font fontCheck = new Font("HelveticaNeueWorld-45Lt", 0, 16);
        this.m_btnCheckSeal = new JButton("Check Sealing Logs");
        this.m_btnCheckSeal.addActionListener(new CheckSealListener(this));
        url = MainFrame.class.getResource("/resource/html.png");
        this.m_btnCheckSeal.setIcon(new ImageIcon(url));
        this.m_btnCheckSeal.setFont(fontCheck);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.addComponent(mainPanel, this.m_labelIcon, 0, 1, 3, 1, 10, 1, 5, 5);
        this.addComponent(mainPanel, m_labelAutomaticMode, 0, 0, 3, 1, 10, 1, 5, 5);
        this.addComponent(mainPanel, this.m_labelImportSeal, 0, 2, 3, 1, 10, 1, 5, 5);
        this.addComponent(mainPanel, this.m_labelError, 0, 3, 3, 1, 10, 1, 5, 5);
        this.addComponent(mainPanel, this.m_btnCheckSeal, 0, 4, 3, 1, 10, 1, 5, 5);
        this.add(mainPanel);
        this.setSize(650, 400);
        this.setMinimumSize(this.getSize());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        if (!existFile) {
            boolean isAutoMode = MsgBox.confirm("Do you want to set Automatic Mode?");
            if (isAutoMode) {
                DataManager.m_autoMode = true;
                System.out.println("AUTOMODE ON");
                m_labelAutomaticMode.setVisible(true);
            } else {
                DataManager.m_autoMode = false;
                System.out.println("AUTOMODE OFF");
                m_labelAutomaticMode.setVisible(false);
            }
            Utility.UploadFile(Utility.OPTION_PATH);
        } else if (DataManager.m_autoMode) {
            this.showAutoMode(true);
        } else {
            this.showAutoMode(false);
        }
    }

    private JMenu getMainMenu() {
        JMenu mainMenu = new JMenu("Menu");
        JMenu importItem = this.getImportMenu();
        mainMenu.add(importItem);
        importItem.addActionListener(new ConnectedListener(this));
        JMenuItem optionsItem = new JMenuItem("Options");
        mainMenu.add(optionsItem);
        optionsItem.addActionListener(new OptionsListener(this));
        JMenuItem aboutItem = new JMenuItem("About");
        mainMenu.add(aboutItem);
        aboutItem.addActionListener(new AboutListener(this));
        return mainMenu;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, int borderLeft, int borderRight) {
        Insets insets = new Insets(10, borderLeft, 10, borderRight);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    public void notifyCheckSeal() {
        this.m_GUIManagerParent.openSealerFilesDir();
    }

    public void notifyConnectedFrame() {
        this.m_GUIManagerParent.notifyConnectedFrame();
    }

    public void notifyNotConnectedFrame() {
        this.m_GUIManagerParent.notifyNotConnectedFrame();
    }

    public void notifyOptionsFrame() {
        this.m_GUIManagerParent.notifyOptionsFrame();
    }

    public void notifyAboutFrame() {
        this.m_GUIManagerParent.notifyAboutFrame();
    }

    public void setSealNumber(int sealsNumber) {
        String seal = "<html><span style=\"font-family:HelveticaNeueWorld-45Lt;font-size:13px;\"></span>" + sealsNumber + "<span style=\\\"font-family:HelveticaNeueWorld-45Lt;font-size:13px;\\\"> sealing logs imported.</span></html>";
        this.m_labelImportSeal.setText(seal);
    }

    public void setError(String error) {
        this.m_labelError.setText(error);
    }

    public void showAutoMode(boolean isAutoMode) {
        m_labelAutomaticMode.setVisible(isAutoMode);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.m_btnCheckSeal.setEnabled(!this.m_GUIManagerParent.isSealerFilesDirEmpty());
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    private JMenu getImportMenu() {
        JMenu importMenu = new JMenu("Import");
        JMenuItem connectedItem = new JMenuItem("SealVal\u00b2 Connected");
        importMenu.add(connectedItem);
        connectedItem.addActionListener(new ConnectedListener(this));
        JMenuItem notConnectedItem = new JMenuItem("SealVal\u00b2 Not Connected");
        importMenu.add(notConnectedItem);
        notConnectedItem.addActionListener(new NotConnectedListener(this));
        return importMenu;
    }

    @Override
    public void menuSelected(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public int getTimeAutoMode() {
        return 0;
    }

    public class AboutListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public AboutListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyAboutFrame();
        }
    }

    public class CheckSealListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public CheckSealListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyCheckSeal();
        }
    }

    public class ConnectedListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public ConnectedListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyConnectedFrame();
        }
    }

    public class NotConnectedListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public NotConnectedListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyNotConnectedFrame();
        }
    }

    public class OptionsListener
    implements ActionListener {
        private MainFrame m_MainFrame;

        public OptionsListener(MainFrame mainFrame2) {
            this.m_MainFrame = mainFrame2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_MainFrame.notifyOptionsFrame();
        }
    }
}

