/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImportNotConnectedFrame
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private JLabel m_labelSourceFolder;
    private JTextField m_txtSourceFolder;
    private JButton m_btnSourceFolder;
    private JLabel m_labelDestFolder;
    private JTextField m_txtDestFolder;
    private JButton m_btnDestFolder;
    private JButton m_btnImport;
    private GUIManager m_GUIManagerParent;

    public ImportNotConnectedFrame(GUIManager GUIManagerParent) {
        this.setTitle("SealVal\u00b2 Not connected");
        this.setModal(true);
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon mainIcon = new ImageIcon(url);
        this.setIconImage(mainIcon.getImage());
        this.addWindowListener(this);
        this.m_GUIManagerParent = GUIManagerParent;
    }

    public void createLayout() {
        Font font = new Font("HelveticaNeueWorld-45Lt", 0, 16);
        this.m_labelSourceFolder = new JLabel("Source folder");
        this.m_labelSourceFolder.setFont(font);
        this.m_labelDestFolder = new JLabel("Destination folder");
        this.m_labelDestFolder.setFont(font);
        this.m_btnSourceFolder = new JButton("Browse...");
        URL url = MainFrame.class.getResource("/resource/folder.png");
        this.m_btnSourceFolder.setIcon(new ImageIcon(url));
        this.m_btnSourceFolder.setIconTextGap(12);
        this.m_btnSourceFolder.setFont(font);
        this.m_btnDestFolder = new JButton("Browse...");
        this.m_btnDestFolder.setIcon(new ImageIcon(url));
        this.m_btnDestFolder.setIconTextGap(12);
        this.m_btnDestFolder.setFont(font);
        this.m_btnImport = new JButton("Import");
        url = MainFrame.class.getResource("/resource/import.png");
        this.m_btnImport.setIcon(new ImageIcon(url));
        this.m_btnImport.setIconTextGap(12);
        this.m_btnImport.setFont(font);
        this.m_txtSourceFolder = new JTextField(20);
        this.m_txtSourceFolder.setFont(font);
        this.m_txtDestFolder = new JTextField(20);
        this.m_txtDestFolder.setFont(font);
        this.m_btnSourceFolder.addActionListener(new SourceListener(this));
        this.m_btnDestFolder.addActionListener(new DestBtnListener(this));
        this.m_btnImport.addActionListener(new ImportNotConnectedBtnListener(this));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.addComponent(mainPanel, this.m_labelSourceFolder, 0, 0, 4, 1, 10, 1, 15, 5, 10, 0);
        this.addComponent(mainPanel, this.m_txtSourceFolder, 0, 1, 3, 1, 10, 1, 15, 0, 0, 20);
        this.addComponent(mainPanel, this.m_btnSourceFolder, 3, 1, 1, 1, 10, 1, 0, 15, 0, 20);
        this.addComponent(mainPanel, this.m_labelDestFolder, 0, 2, 4, 1, 10, 1, 15, 5, 10, 0);
        this.addComponent(mainPanel, this.m_txtDestFolder, 0, 3, 3, 1, 10, 1, 15, 0, 0, 20);
        this.addComponent(mainPanel, this.m_btnDestFolder, 3, 3, 1, 1, 10, 1, 0, 15, 0, 20);
        this.addComponent(mainPanel, this.m_btnImport, 0, 4, 4, 2, 10, 1, 15, 15, 10, 10);
        this.add(mainPanel);
        this.setSize(500, 300);
        this.setMinimumSize(this.getSize());
        this.setMaximumSize(this.getSize());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, int borderLeft, int borderRight, int borderTop, int borderBottom) {
        Insets insets = new Insets(borderTop, borderLeft, borderBottom, borderRight);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    public void setSourcePath(String sourceDirectory) {
        this.m_txtSourceFolder.setText(sourceDirectory);
    }

    public void setDestinationPath(String destDirectory) {
        this.m_txtDestFolder.setText(destDirectory);
    }

    public void notifyImportNotConnected() {
        String sourceDirectory = this.m_txtSourceFolder.getText();
        String destDirectory = this.m_txtDestFolder.getText();
        if (sourceDirectory.isEmpty() || destDirectory.isEmpty()) {
            MsgBox.error("Wrong input data");
        } else {
            this.m_GUIManagerParent.notifyImportNotConnected(sourceDirectory);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        Dimension sourceDim = this.m_txtSourceFolder.getSize();
        Dimension btnDim = this.m_btnSourceFolder.getSize();
        this.m_txtSourceFolder.setSize(sourceDim.width, btnDim.height);
        Dimension destDim = this.m_txtDestFolder.getSize();
        Dimension btndestDim = this.m_btnDestFolder.getSize();
        this.m_txtDestFolder.setSize(destDim.width, btndestDim.height);
        Point locationSou = this.m_txtSourceFolder.getLocation();
        Point locationBtnSou = this.m_btnSourceFolder.getLocation();
        this.m_btnSourceFolder.setLocation(locationBtnSou.x, locationSou.y);
        Point locationDest = this.m_txtDestFolder.getLocation();
        Point locationBtnDest = this.m_btnDestFolder.getLocation();
        this.m_btnDestFolder.setLocation(locationBtnDest.x, locationDest.y);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class DestBtnListener
    implements ActionListener {
        private ImportNotConnectedFrame m_MainParent;

        public DestBtnListener(ImportNotConnectedFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileHidingEnabled(false);
            int result = fileChooser.showOpenDialog(this.m_MainParent);
            if (result == 0) {
                File destFile = fileChooser.getSelectedFile();
                this.m_MainParent.setDestinationPath(destFile.getAbsolutePath());
            }
        }
    }

    class ImportNotConnectedBtnListener
    implements ActionListener {
        private ImportNotConnectedFrame m_MainParent;

        public ImportNotConnectedBtnListener(ImportNotConnectedFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.m_MainParent.notifyImportNotConnected();
        }
    }

    class SourceListener
    implements ActionListener {
        private ImportNotConnectedFrame m_MainParent;

        public SourceListener(ImportNotConnectedFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileHidingEnabled(false);
            int result = fileChooser.showOpenDialog(this.m_MainParent);
            if (result == 0) {
                File souFile = fileChooser.getSelectedFile();
                this.m_MainParent.setSourcePath(souFile.getAbsolutePath());
            }
        }
    }
}

