/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImportConnectedFrame
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private JLabel m_labelIPAddress;
    private JTextField m_txtIPAddress;
    private JLabel m_labelDestFolder;
    private JTextField m_txtDestFolder;
    private JButton m_btnDestFolder;
    private JButton m_btnImport;
    private GUIManager m_GUIManagerParent;

    public ImportConnectedFrame(GUIManager GUIManagerParent) {
        this.setTitle("SealVal\u00b2 Connected");
        this.setModal(true);
        URL url = MainFrame.class.getResource("/resource/logo.png");
        ImageIcon mainIcon = new ImageIcon(url);
        this.setIconImage(mainIcon.getImage());
        this.addWindowListener(this);
        this.m_GUIManagerParent = GUIManagerParent;
    }

    public void createLayout() {
        Font font = new Font("HelveticaNeueWorld-45Lt", 0, 16);
        this.m_labelIPAddress = new JLabel("SealVal\u00b2 IP address");
        this.m_labelIPAddress.setFont(font);
        this.m_labelDestFolder = new JLabel("Destination folder");
        this.m_labelDestFolder.setFont(font);
        this.m_btnDestFolder = new JButton("Browse...");
        URL url = MainFrame.class.getResource("/resource/folder.png");
        this.m_btnDestFolder.setIcon(new ImageIcon(url));
        this.m_btnDestFolder.setIconTextGap(12);
        this.m_btnDestFolder.setFont(font);
        this.m_btnImport = new JButton("Import");
        url = MainFrame.class.getResource("/resource/import.png");
        this.m_btnImport.setIcon(new ImageIcon(url));
        this.m_btnImport.setIconTextGap(12);
        this.m_btnImport.setFont(font);
        this.m_txtIPAddress = new JTextField(20);
        this.m_txtIPAddress.setFont(font);
        this.m_txtDestFolder = new JTextField(20);
        this.m_txtDestFolder.setFont(font);
        this.m_btnDestFolder.addActionListener(new DestFolderBtnListener(this));
        this.m_btnImport.addActionListener(new ImportConnectedBtnListener(this));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.addComponent(mainPanel, this.m_labelIPAddress, 0, 0, 4, 1, 10, 1, 15, 5, 10, 0);
        this.addComponent(mainPanel, this.m_txtIPAddress, 0, 1, 4, 1, 10, 1, 15, 15, 0, 20);
        this.addComponent(mainPanel, this.m_labelDestFolder, 0, 2, 4, 1, 10, 1, 15, 5, 10, 0);
        this.addComponent(mainPanel, this.m_txtDestFolder, 0, 3, 3, 1, 10, 1, 15, 0, 0, 20);
        this.addComponent(mainPanel, this.m_btnDestFolder, 3, 3, 1, 1, 10, 1, 0, 15, 0, 20);
        this.addComponent(mainPanel, this.m_btnImport, 0, 4, 4, 2, 10, 1, 15, 15, 10, 10);
        this.add(mainPanel);
        this.setSize(500, 300);
        this.setMinimumSize(this.getSize());
        this.setMaximumSize(this.getSize());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, int borderLeft, int borderRight, int borderTop, int borderBottom) {
        Insets insets = new Insets(borderTop, borderLeft, borderBottom, borderRight);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    public void setIPAddress(String IPAddress) {
        this.m_txtIPAddress.setText(IPAddress);
    }

    public void setDestinationPath(String destDirectory) {
        this.m_txtDestFolder.setText(destDirectory);
    }

    public void notifyImportConnected() {
        String ipAddress = this.m_txtIPAddress.getText();
        String destDirectory = this.m_txtDestFolder.getText();
        if (ipAddress.isEmpty() || destDirectory.isEmpty() || !this.checkIPAddress(ipAddress)) {
            MsgBox.error("Wrong input data");
        } else {
            DataManager.m_IPAddress = ipAddress;
            DataManager.m_destFolder = destDirectory;
            this.m_GUIManagerParent.notifyImportConnected();
        }
    }

    public boolean checkIPAddress(String IPAddress) {
        String zeroTo255 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String regex = String.valueOf(zeroTo255) + "\\." + zeroTo255 + "\\." + zeroTo255 + "\\." + zeroTo255;
        Pattern p = Pattern.compile(regex);
        if (IPAddress == null) {
            return false;
        }
        Matcher m = p.matcher(IPAddress);
        return m.matches();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        Dimension destDim = this.m_txtDestFolder.getSize();
        Dimension btndestDim = this.m_btnDestFolder.getSize();
        this.m_txtDestFolder.setSize(destDim.width, btndestDim.height);
        this.m_txtDestFolder.setText(DataManager.m_destFolder);
        Dimension sourceDim = this.m_txtIPAddress.getSize();
        this.m_txtIPAddress.setSize(sourceDim.width, destDim.height);
        this.m_txtIPAddress.setText(DataManager.m_IPAddress);
        Point locationDest = this.m_txtDestFolder.getLocation();
        Point locationBtnDest = this.m_btnDestFolder.getLocation();
        this.m_btnDestFolder.setLocation(locationBtnDest.x, locationDest.y);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        DataManager.m_IPAddress = this.m_txtIPAddress.getText();
        DataManager.m_destFolder = this.m_txtDestFolder.getText();
        System.out.println("Chiusura");
        Utility.UploadFile(Utility.OPTION_PATH);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class DestFolderBtnListener
    implements ActionListener {
        private ImportConnectedFrame m_MainParent;

        public DestFolderBtnListener(ImportConnectedFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileHidingEnabled(false);
            int result = fileChooser.showOpenDialog(this.m_MainParent);
            if (result == 0) {
                File destFile = fileChooser.getSelectedFile();
                this.m_MainParent.setDestinationPath(destFile.getAbsolutePath());
            }
        }
    }

    class ImportConnectedBtnListener
    implements ActionListener {
        private ImportConnectedFrame m_MainParent;

        public ImportConnectedBtnListener(ImportConnectedFrame mainParent) {
            this.m_MainParent = mainParent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.m_MainParent.notifyImportConnected();
        }
    }
}

