/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class Lot {
    public final String STERILE = "00";
    public final String CUSTOM = "01";
    public final String SEAL_CHEACK = "12";
    public final String PEEL_TEST = "13";
    public final String VALID_PROG = "14";
    public final String TOKEN_UNDERSCORE = "_";
    public final String TOKEN_STERILE = "Standard";
    public final String TOKEN_CUSTOM = "Custom";
    public final String TOKEN_SEAL_CHEACK = "Seal Check";
    public final String TOKEN_PEEL_TEST = "Peel test";
    public final String TOKEN_VALID_PROG = "Validation Program";
    private String m_lotID = new String();
    private String m_lotFileName = new String();
    private String m_firwareVersion = new String();
    private String m_sealerSN = new String();
    private List<Seal> m_lotSeals = new ArrayList<Seal>();

    public boolean importSeal(Seal singleSeal) {
        if (this.getFirwareVersion().isEmpty() && this.getSealerSN().isEmpty() && this.getLotID().isEmpty()) {
            this.setFirwareVersion(singleSeal.getFirmwareVersion());
            this.setSealerSN(singleSeal.getSealerSN());
            this.setLotID(singleSeal.getIDSessionSealing());
        } else if (!(this.getFirwareVersion().equals(singleSeal.getFirmwareVersion()) && this.getSealerSN().equals(singleSeal.getSealerSN()) && this.getLotID().equals(singleSeal.getIDSessionSealing()))) {
            this.m_lotSeals.clear();
            return false;
        }
        return this.m_lotSeals.add(singleSeal);
    }

    public List<String> getDifferentDateInLot() {
        int i = 0;
        ArrayList<String> suppList = new ArrayList<String>();
        suppList.clear();
        i = 0;
        while (i < this.m_lotSeals.size()) {
            Seal supportSeal = this.m_lotSeals.get(i);
            if (!suppList.contains(supportSeal.getDateSealing())) {
                suppList.add(supportSeal.getDateSealing());
            }
            ++i;
        }
        return suppList;
    }

    public String getLotID() {
        return this.m_lotID;
    }

    public void setLotID(String lotID) {
        this.m_lotID = lotID;
    }

    public String getLotFileName() {
        return this.m_lotFileName;
    }

    public void setLotFileName(String lotFileName) {
        String[] parts = lotFileName.split("_", 2);
        String name = parts[0];
        String codeExtension = parts[1];
        if (codeExtension.contains("00")) {
            name = String.valueOf(name) + "_" + "Standard";
        } else if (codeExtension.contains("01")) {
            name = String.valueOf(name) + "_" + "Custom";
        } else if (codeExtension.contains("12")) {
            name = String.valueOf(name) + "_" + "Seal Check";
        } else if (codeExtension.contains("13")) {
            name = String.valueOf(name) + "_" + "Peel test";
        } else if (codeExtension.contains("14")) {
            name = String.valueOf(name) + "_" + "Validation Program";
        } else {
            String[] code = codeExtension.split(".", 2);
            name = String.valueOf(name) + "_" + code[0];
        }
        this.m_lotFileName = name;
    }

    public List<Seal> getLotSeals() {
        return this.m_lotSeals;
    }

    public void setLotSeals(List<Seal> lotSeals) {
        this.m_lotSeals = lotSeals;
    }

    public String getFirwareVersion() {
        return this.m_firwareVersion;
    }

    public void setFirwareVersion(String firwareVersion) {
        this.m_firwareVersion = firwareVersion;
    }

    public String getSealerSN() {
        return this.m_sealerSN;
    }

    public void setSealerSN(String sealerSN) {
        this.m_sealerSN = sealerSN;
    }
}

