/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GUIManager {
    private Timer m_timer = null;
    private Thread m_importBkThread;
    private LoadingBox m_loadingBox;
    private MainFrame m_mainFrame;
    private OptionsFrame m_optionsFrame;
    private AboutFrame m_aboutFrame;
    private ImportConnectedFrame m_connectedFrame;
    private ImportNotConnectedFrame m_notConnectedFrame;
    private DataManager m_dataMgr = new DataManager();

    public GUIManager() {
        this.m_mainFrame = new MainFrame(this);
    }

    public void initialize() {
        boolean existFile = Utility.DownloadFile(Utility.OPTION_PATH);
        if (existFile && this.m_dataMgr.isAutoMode()) {
            this.startAutoMode();
        }
        this.m_mainFrame.createLayout(existFile);
    }

    public void showDialogs(boolean bShow) {
        this.m_mainFrame.setVisible(bShow);
    }

    public void notifyImportConnected() {
        this.m_loadingBox = new LoadingBox();
        this.m_loadingBox.createLayout();
        this.m_importBkThread = new Thread(){

            @Override
            public void run() {
                try {
                    GUIManager.this.notifyConnectedImport();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUIManager.this.m_loadingBox.dispose();
                        GUIManager.this.m_loadingBox = null;
                    }
                });
            }
        };
        if (this.m_importBkThread != null && !this.m_importBkThread.isAlive()) {
            this.m_importBkThread.start();
        }
        this.m_loadingBox.setVisible(true);
        if (this.m_importBkThread != null) {
            this.m_importBkThread.interrupt();
            try {
                this.m_importBkThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.m_importBkThread = null;
        }
        this.m_connectedFrame.dispose();
        this.m_connectedFrame = null;
    }

    public void notifyImportNotConnected(final String sourceFolder) {
        DataManager.m_autoMode = false;
        this.stopAutoMode();
        this.m_mainFrame.showAutoMode(false);
        Utility.UploadFile(Utility.OPTION_PATH);
        this.m_loadingBox = new LoadingBox();
        this.m_loadingBox.createLayout();
        this.m_importBkThread = new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Start import in bg");
                    GUIManager.this.notifyNotConnectedImport(sourceFolder, DataManager.m_destFolder);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUIManager.this.m_loadingBox.dispose();
                        GUIManager.this.m_loadingBox = null;
                    }
                });
            }
        };
        if (this.m_importBkThread != null && !this.m_importBkThread.isAlive()) {
            this.m_importBkThread.start();
        }
        this.m_loadingBox.setVisible(true);
        if (this.m_importBkThread != null) {
            this.m_importBkThread.interrupt();
            try {
                this.m_importBkThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.m_importBkThread = null;
        }
        this.m_notConnectedFrame.dispose();
        this.m_notConnectedFrame = null;
    }

    public void startAutoMode() {
        if (this.m_timer == null) {
            this.m_timer = new Timer();
            this.m_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    System.out.println("Start Polling...");
                    System.out.println("Polling time: " + GUIManager.this.m_dataMgr.getPollingTime());
                    GUIManager.this.notifyConnectedImport();
                }
            }, 3000L, (long)(this.m_dataMgr.getPollingTime() * 1000));
        }
    }

    public void stopAutoMode() {
        System.out.println("Stop polling...");
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer.purge();
            this.m_timer = null;
        }
    }

    public boolean isSealerFilesDirEmpty() {
        return this.m_dataMgr.getDestFolder().isEmpty();
    }

    public void openSealerFilesDir() {
        block5: {
            if (!this.m_dataMgr.getDestFolder().isEmpty()) {
                try {
                    File destinationFolder = new File(this.m_dataMgr.getDestFolder());
                    if (destinationFolder.exists()) {
                        Desktop.getDesktop().open(destinationFolder);
                        break block5;
                    }
                    MsgBox.error("Invalid destination folder");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                MsgBox.error("Invalid destination folder");
            }
        }
    }

    public void notifyConnectedFrame() {
        this.m_connectedFrame = new ImportConnectedFrame(this);
        this.m_connectedFrame.createLayout();
        this.m_connectedFrame.setIPAddress(this.m_dataMgr.getIpAddress());
        this.m_connectedFrame.setDestinationPath(this.m_dataMgr.getDestFolder());
        this.m_connectedFrame.setVisible(true);
        this.stopAutoMode();
        if (this.m_dataMgr.isAutoMode()) {
            this.startAutoMode();
        } else {
            this.notifyConnectedImport();
        }
    }

    public void notifyNotConnectedFrame() {
        this.m_notConnectedFrame = new ImportNotConnectedFrame(this);
        this.m_notConnectedFrame.createLayout();
        this.m_notConnectedFrame.setSourcePath("");
        this.m_notConnectedFrame.setDestinationPath(this.m_dataMgr.getDestFolder());
        this.m_notConnectedFrame.setVisible(true);
    }

    public void notifyConnectedImport() {
        boolean result = this.m_dataMgr.importFilesFromFTP();
        result = result && this.m_dataMgr.exportFiles();
        ImportExportReport report = this.m_dataMgr.getReport();
        this.showReportData(report);
    }

    public void notifyNotConnectedImport(String sourceDirectory, String destDirectory) {
        System.out.println("----- Source Directory: " + sourceDirectory);
        boolean result = this.m_dataMgr.importFilesFromDirectory(sourceDirectory, destDirectory);
        result = result && this.m_dataMgr.exportFiles();
        ImportExportReport report = this.m_dataMgr.getReport();
        this.showReportData(report);
    }

    public void notifyOptionsFrame() {
        this.m_optionsFrame = new OptionsFrame(this);
        this.m_optionsFrame.createLayout();
        this.m_optionsFrame.setVisible(true);
    }

    public void notifyOptionsChange(int timeAutoMode) {
        this.m_dataMgr.setPollingTime(timeAutoMode);
        this.m_optionsFrame.dispose();
        this.m_optionsFrame = null;
        this.stopAutoMode();
        if (this.m_dataMgr.isAutoMode()) {
            this.startAutoMode();
        }
    }

    public void notifyAboutFrame() {
        this.m_aboutFrame = new AboutFrame();
        this.m_aboutFrame.createLayout();
        this.m_aboutFrame.setVisible(true);
    }

    public void showReportData(ImportExportReport report) {
        if (report.getError().isEmpty()) {
            this.m_mainFrame.setError(report.getError());
        } else {
            this.m_mainFrame.setError(report.getError());
        }
        if (report.getError().isEmpty() && report.getError().isEmpty()) {
            this.m_mainFrame.setSealNumber(report.getSealsNumber());
        } else {
            this.m_mainFrame.setSealNumber(0);
        }
    }

    public JFrame getFrame() {
        return this.m_mainFrame;
    }
}

