/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;

public class DataManager {
    public final String SOTWARE_REVISION = "2.0";
    public final String TEMP_WHFOLDER = "FTPTempWH";
    private ImportExportReport m_report;
    private List<Lot> m_sealerLot = new ArrayList<Lot>();
    static String m_IPAddress;
    static String m_destFolder;
    static int m_pollingTime;
    static boolean m_autoMode;

    public DataManager() {
        this.m_sealerLot.clear();
        this.m_report = new ImportExportReport();
        m_IPAddress = new String();
        m_destFolder = new String();
        m_pollingTime = 10;
        m_autoMode = false;
    }

    private String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public boolean importFilesFromDirectory(String sourceDirectory, String destDirectory) {
        this.m_report.reset();
        return this.importFiles(sourceDirectory);
    }

    public boolean importFilesFromFTP() {
        boolean result = false;
        String sourceDirectory = "";
        this.m_report.reset();
        sourceDirectory = this.getFTPTempFolder(m_IPAddress, "", "", "");
        if (sourceDirectory.isEmpty()) {
            this.m_report.setError("Connection error");
        } else {
            result = this.importFiles(sourceDirectory);
            result = result && this.removeTempFTPFolder();
        }
        return result;
    }

    public boolean importFiles(String sourceDirectory) {
        File[] listOfFiles;
        boolean result = false;
        boolean incongruentData = false;
        int sealerImportedCount = 0;
        int lineCount = 0;
        File folder = new File(sourceDirectory);
        if (!folder.exists()) {
            this.m_report.setError("Folder \"" + sourceDirectory + "\" not found");
            return result;
        }
        File[] fileArray = listOfFiles = folder.listFiles();
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            System.out.println("Start importing file...");
            if (file.isFile() && this.getFileExtension(file).toLowerCase().equals("sys")) {
                String line = null;
                Lot lot = null;
                try {
                    FileReader fileReader = new FileReader(file.getPath());
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    System.out.println("Buffered lines: " + bufferedReader.lines());
                    lot = new Lot();
                    result = true;
                    lineCount = 0;
                    while ((line = bufferedReader.readLine()) != null && result) {
                        ++lineCount;
                        Seal singleSeal = new Seal();
                        result = singleSeal.importSeal(line);
                        if (!result) {
                            this.m_report.setError("Error in file \"" + file.getName() + "\", line \"" + lineCount + "\".");
                            continue;
                        }
                        boolean bl = result = result && lot.importSeal(singleSeal);
                        if (!result) {
                            this.m_report.setError("Wrong SN, Lot Number or Firmware version in file \"" + file.getName() + "\", line \"" + lineCount + "\".");
                            incongruentData = true;
                            continue;
                        }
                        String fileName = file.getName().substring(0, file.getName().lastIndexOf("."));
                        lot.setLotFileName(fileName);
                        ++sealerImportedCount;
                    }
                    if (result && !incongruentData) {
                        this.m_report.setSealsNumber(sealerImportedCount);
                    }
                    bufferedReader.close();
                    this.m_sealerLot.add(lot);
                }
                catch (FileNotFoundException ex) {
                    this.m_report.setError("Impossible to open file \"" + file.getPath() + "\"");
                    result = false;
                }
                catch (IOException ex) {
                    this.m_report.setError("Error reading file \"" + file.getPath() + "\"");
                    result = false;
                }
            }
            ++n2;
        }
        return result;
    }

    private boolean removeTempFTPFolder() {
        File folder = new File(String.valueOf(m_destFolder) + File.separator + "FTPTempWH");
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        return folder.delete();
    }

    public String getFTPTempFolder(String souDirectory, String ftpUser, String ftpPassword, String ftpPort) {
        boolean result = false;
        String server = souDirectory;
        String user = ftpUser;
        String pass = ftpPassword;
        String port = ftpPort;
        FTPClientConfig configFTP = null;
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            configFTP = new FTPClientConfig("WINDOWS");
        } else if (OS.indexOf("mac") >= 0) {
            configFTP = new FTPClientConfig("MACOS PETER");
        } else {
            return "";
        }
        FTPClient ftpClient = new FTPClient();
        try {
            if (!ftpPort.isEmpty()) {
                ftpClient.setDefaultPort(Integer.parseInt(port));
            }
            ftpClient.connect(server);
            ftpClient.login(user, pass);
            ftpClient.configure(configFTP);
            System.out.println("Start import: " + ftpClient.isConnected());
            File folder = new File(String.valueOf(m_destFolder) + File.separator + "FTPTempWH");
            folder.mkdir();
            if (folder.exists()) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    f.delete();
                    ++n2;
                }
                String[] listName = ftpClient.listNames();
                result = true;
                System.out.println("Length: " + listName.length);
                int i = 0;
                while (i < listName.length) {
                    if (listName[i].toLowerCase().contains(".sys")) {
                        FileOutputStream output = new FileOutputStream(String.valueOf(folder.getPath()) + File.separator + listName[i]);
                        result = result && ftpClient.retrieveFile(listName[i], (OutputStream)output);
                        ((OutputStream)output).close();
                    }
                    ++i;
                }
            }
            ftpClient.logout();
        }
        catch (IOException e) {
            this.m_report.setError("Connection error");
        }
        catch (NullPointerException e) {
            this.m_report.setError("Card not detected, insert card and retry sealing");
            System.out.println("listName null");
        }
        if (result) {
            return String.valueOf(m_destFolder) + File.separator + "FTPTempWH";
        }
        return "";
    }

    public boolean exportFiles() {
        try {
            int i = 0;
            while (i < this.m_sealerLot.size()) {
                Lot lot = this.m_sealerLot.get(i);
                OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(m_destFolder) + File.separator + lot.getLotFileName() + ".html"), StandardCharsets.UTF_8);
                String html = this.getHeaderHtml(lot.getSealerSN());
                html = String.valueOf(html) + "<body><table width=400 cellpadding=1>\n";
                html = String.valueOf(html) + "<tr align=center><td colspan=\"7\"/>W&H Sterilization</td></tr>\n";
                html = String.valueOf(html) + "<tr align=center><td colspan=\"5\"><b>SealVal\u00b2</b></td><td colspan=\"2\"><b>SN:" + lot.getSealerSN() + "</b></td></tr></table> \n";
                html = String.valueOf(html) + "</b></td></tr></table>\n";
                html = String.valueOf(html) + "<table width=400>\n";
                html = String.valueOf(html) + "<tr align=left><td colspan=\"2\">Software revision:</td><td colspan=\"3\">2.0</td></tr> \n";
                html = String.valueOf(html) + "<tr align=left><td colspan=\"2\">Firmware version:</td><td colspan=\"3\">" + lot.getFirwareVersion() + "</td></tr> \n";
                html = String.valueOf(html) + "<tr align=left><td colspan=\"2\">Sealing lot number:</td><td colspan=\"3\">" + lot.getLotID() + "</td></tr> \n";
                html = String.valueOf(html) + "<tr><td colspan=\"5\"><hr size=2></td></tr></table> \n";
                html = String.valueOf(html) + "<table width=400 bgcolor=\"#F8F8F8\"> \n";
                List<String> dateList = lot.getDifferentDateInLot();
                int k = 0;
                while (k < dateList.size()) {
                    html = String.valueOf(html) + "<tr align=center><td>Date:</td><td colspan=\"7\">" + dateList.get(k) + "</td></tr> \n";
                    html = String.valueOf(html) + "<!-- StartTime=\"" + dateList.get(k) + " \" --> \n";
                    html = String.valueOf(html) + "<tr align=center><td><b>ID seal.</b></td><td><b>Start time</b></td><td><b>T \u00b0C</b></td><td><b>P.bar</b></td><td><b>Time(s)</b></td><td><b>Operator</b></td><td><b>Result</b></td></tr> \n";
                    html = String.valueOf(html) + "<!-- HeaderId=\"00\" --> \n";
                    List<Seal> seals = lot.getLotSeals();
                    int j = 0;
                    while (j < seals.size()) {
                        Seal singleSeam = seals.get(j);
                        if (singleSeam.getDateSealing().equals(dateList.get(k))) {
                            html = String.valueOf(html) + "<tr align=center><td>" + singleSeam.getIDSealing() + "</td><td>" + singleSeam.getTimeSealing() + "</td><td>" + singleSeam.getTemperatureSealing() + "</td><td>" + singleSeam.getPressureSealing() + "</td><td>" + singleSeam.getDurationSealing() + "</td><td>" + singleSeam.getIDOperator() + "</td>";
                            html = singleSeam.getResultSealing() == 0 ? String.valueOf(html) + "<td><font color=\"green\">Passed</font></td></tr> \n" : String.valueOf(html) + "<td><font color=\"red\">Failed</font></td></tr> \n";
                            html = String.valueOf(html) + "<!-- IDSealing==\"" + singleSeam.getIDSealing() + "\" TimeSealing=\"" + singleSeam.getTimeSealing() + "\" TemperatureSealing=\"" + singleSeam.getTemperatureSealing() + "\" PressureSealing=\"" + singleSeam.getPressureSealing() + "\" DurationSealing=\"" + singleSeam.getDurationSealing() + "\" OperatorID=\"" + singleSeam.getIDOperator() + "\" Result=\"" + singleSeam.getResultSealing() + "\" -->\n";
                        }
                        ++j;
                    }
                    html = String.valueOf(html) + "<tr><td colspan=\"7\"><hr size=2></td></tr>\n";
                    ++k;
                }
                String htmlBody = html;
                html = this.getEnderHtml(htmlBody);
                os.write(html);
                os.close();
                html = "";
                ++i;
            }
        }
        catch (IOException e) {
            this.m_report.setError("Open HTML file error");
            this.m_sealerLot.clear();
            return false;
        }
        this.m_sealerLot.clear();
        return true;
    }

    public String getHeaderHtml(String SNSealer) {
        String html = "<html><head>";
        html = String.valueOf(html) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>";
        html = String.valueOf(html) + "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/>";
        html = String.valueOf(html) + "<title>";
        html = String.valueOf(html) + "W&H Sterilization";
        html = String.valueOf(html) + " </title>";
        html = String.valueOf(html) + "</head>\n";
        html = String.valueOf(html) + "<!-- DeviceBrandID=\"";
        html = String.valueOf(html) + "\" DeviceBrand=\"W&H Sterilization";
        html = String.valueOf(html) + "\" DeviceSN=\"" + SNSealer;
        html = String.valueOf(html) + "\" -->\n";
        return html;
    }

    public String getControlCode(String Html, String footer) {
        int uwSum = Utility.uwChkSumSum(Html);
        int ubChkSum = Utility.ubCheckSum8(Html);
        int[] RawControlCode = new int[8];
        byte[] byteArrHtml = Html.getBytes();
        byte[] byteArrFooter = footer.getBytes();
        int ulDimFile = byteArrHtml.length + RawControlCode.length * 2 + byteArrFooter.length;
        RawControlCode[0] = ulDimFile >>> 24 & 0xFF;
        RawControlCode[1] = ulDimFile >>> 16 & 0xFF;
        RawControlCode[2] = ulDimFile >>> 8 & 0xFF;
        RawControlCode[3] = ulDimFile & 0xFF;
        RawControlCode[4] = ubChkSum & 0xFF;
        RawControlCode[5] = uwSum >>> 8 & 0xFF;
        RawControlCode[6] = uwSum & 0xFF;
        int ubCS8 = 0;
        int ulIndex = 0;
        while (ulIndex < 7) {
            ubCS8 = (ubCS8 >>> 1 | ubCS8 << 7) & 0xFF;
            ubCS8 += RawControlCode[ulIndex];
            ubCS8 &= 0xFF;
            ++ulIndex;
        }
        RawControlCode[7] = ubCS8;
        ulIndex = 0;
        while (ulIndex < 4) {
            int n = 0 + ulIndex;
            RawControlCode[n] = RawControlCode[n] ^ ~((byte)RawControlCode[4 + ulIndex]);
            ++ulIndex;
        }
        String ControlCode = "";
        ulIndex = 0;
        while (ulIndex < RawControlCode.length) {
            ControlCode = String.valueOf(ControlCode) + Utility.ValToHex2(RawControlCode[ulIndex]);
            ++ulIndex;
        }
        return ControlCode;
    }

    public String getEnderHtml(String htmlBody) {
        String html = htmlBody;
        html = String.valueOf(html) + "<table width=400>\n";
        html = String.valueOf(html) + "</table>\n";
        html = String.valueOf(html) + "</body>\n";
        html = String.valueOf(html) + "<!-- Original_Data_Control_Code=\"";
        html = String.valueOf(html) + this.getControlCode(html, "\" -->\n</html>");
        html = String.valueOf(html) + "\" -->\n</html>";
        return html;
    }

    public ImportExportReport getReport() {
        return this.m_report;
    }

    public int getPollingTime() {
        return m_pollingTime;
    }

    public String getIpAddress() {
        return m_IPAddress;
    }

    public String getDestFolder() {
        return m_destFolder;
    }

    public boolean isAutoMode() {
        return m_autoMode;
    }

    public void setPollingTime(int time) {
        m_pollingTime = time;
    }
}

